<?php

namespace App\Controllers;

use App\Models\Model_biodata;
use App\Models\Model_agama;

class biodata extends BaseController
{

    public function __construct()
    {
        $this->Model_biodata = new Model_biodata();
        $this->Model_agama = new Model_agama();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'biodata' => $this->Model_biodata->all_data(),
            'isi'    => 'biodata/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'agama' => $this->Model_agama->all_data(),
            'isi'    => 'biodata/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_lengkap' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_agama' => [
                'label'  => 'agama',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_biodata = $this->request->getFile('file_biodata');
            //merandom nama file foto
            $nama_file = $file_biodata->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_biodata->getSize('kb');
            //jika valid
            $data = array(
                'id_agama' => $this->request->getPost('id_agama'),
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_biodata' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_biodata->move('file_biodata', $nama_file); //directori upload file
            $this->Model_biodata->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('biodata'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('biodata/add'));
        }
    }

    //edit
    public function edit($id_biodata)
    {
        $data = array(
            'title' => 'Edit Document',
            'agama' => $this->Model_agama->all_data(),
            'biodata'    => $this->Model_biodata->detail_data($id_biodata),
            'isi'    => 'biodata/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_biodata)
    {
        if ($this->validate([
            'nama_lengkap' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_agama' => [
                'label'  => 'agama',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_biodata = $this->request->getFile('file_biodata');
            if ($file_biodata->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_biodata'  => $id_biodata,
                    'id_agama' => $this->request->getPost('id_agama'),
                    'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_biodata->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $biodata = $this->Model_biodata->detail_data($id_biodata);
                if ($biodata['file_biodata'] != "") {
                    unlink('file_biodata/' . $biodata['file_biodata']);
                }
                //merandom nama file foto
                $nama_file = $file_biodata->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_biodata->getSize('kb');
                //jika valid
                $data = array(
                    'id_biodata'  => $id_biodata,
                    'id_agama' => $this->request->getPost('id_agama'),
                    'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_biodata' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_biodata->move('file_biodata', $nama_file); //directori upload file
                $this->Model_biodata->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('biodata'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('biodata/edit' . $id_biodata));
        }
    }

    public function delete($id_biodata)
    {
        //menghapus foto lama
        $biodata = $this->Model_biodata->detail_data($id_biodata);
        if ($biodata['file_biodata'] != "") {
            unlink('file_biodata/' . $biodata['file_biodata']);
        }

        $data = array(
            'id_biodata' => $id_biodata,
        );
        $this->Model_biodata->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('biodata'));
    }

    public function viewpdf($id_biodata)
    {
        $data = array(
            'title' => 'View Document',
            'biodata' => $this->Model_biodata->detail_data($id_biodata),
            'isi'    => 'biodata/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
