<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_identitas extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_identitas')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_identitas.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_identitas.id_user', 'left')
            ->join('tbl_kategori_identitas', 'tbl_kategori_identitas.id_kategori_identitas = tbl_identitas.id_kategori_identitas', 'left')
            ->orderBy('id_identitas', 'DESC')
            ->where('tbl_identitas.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_identitas')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_identitas.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_identitas.id_user', 'left')
            ->join('tbl_kategori_identitas', 'tbl_kategori_identitas.id_kategori_identitas = tbl_identitas.id_kategori_identitas', 'left')
            ->orderBy('id_identitas', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_identitas)
    {
        return $this->db->table('tbl_identitas')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_identitas.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_identitas.id_user', 'left')
            ->join('tbl_kategori_identitas', 'tbl_kategori_identitas.id_kategori_identitas = tbl_identitas.id_kategori_identitas', 'left')
            ->where('id_identitas', $id_identitas)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_identitas')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_identitas')
            ->where('id_identitas', $data['id_identitas'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_identitas')
            ->where('id_identitas', $data['id_identitas'])
            ->delete($data);
    }
}
