<?php

namespace App\Controllers;

use App\Models\Model_pelatihan;
use App\Models\Model_kategori_pelatihan;

class pelatihan extends BaseController
{

    public function __construct()
    {
        $this->Model_pelatihan = new Model_pelatihan();
        $this->Model_kategori_pelatihan = new Model_kategori_pelatihan();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'pelatihan' => $this->Model_pelatihan->all_data(),
            'isi'    => 'pelatihan/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_pelatihan' => $this->Model_kategori_pelatihan->all_data(),
            'isi'    => 'pelatihan/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_pelatihan' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_pelatihan' => [
                'label'  => 'kategori_pelatihan',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pelatihan = $this->request->getFile('file_pelatihan');
            //merandom nama file foto
            $nama_file = $file_pelatihan->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_pelatihan->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_pelatihan' => $this->request->getPost('id_kategori_pelatihan'),
                'nama_pelatihan' => $this->request->getPost('nama_pelatihan'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_pelatihan' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_pelatihan->move('file_pelatihan', $nama_file); //directori upload file
            $this->Model_pelatihan->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pelatihan'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pelatihan/add'));
        }
    }

    //edit
    public function edit($id_pelatihan)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_pelatihan' => $this->Model_kategori_pelatihan->all_data(),
            'pelatihan'    => $this->Model_pelatihan->detail_data($id_pelatihan),
            'isi'    => 'pelatihan/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_pelatihan)
    {
        if ($this->validate([
            'nama_pelatihan' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_pelatihan' => [
                'label'  => 'kategori_pelatihan',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pelatihan = $this->request->getFile('file_pelatihan');
            if ($file_pelatihan->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_pelatihan'  => $id_pelatihan,
                    'id_kategori_pelatihan' => $this->request->getPost('id_kategori_pelatihan'),
                    'nama_pelatihan' => $this->request->getPost('nama_pelatihan'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_pelatihan->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $pelatihan = $this->Model_pelatihan->detail_data($id_pelatihan);
                if ($pelatihan['file_pelatihan'] != "") {
                    unlink('file_pelatihan/' . $pelatihan['file_pelatihan']);
                }
                //merandom nama file foto
                $nama_file = $file_pelatihan->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_pelatihan->getSize('kb');
                //jika valid
                $data = array(
                    'id_pelatihan'  => $id_pelatihan,
                    'id_kategori_pelatihan' => $this->request->getPost('id_kategori_pelatihan'),
                    'nama_pelatihan' => $this->request->getPost('nama_pelatihan'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_pelatihan' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_pelatihan->move('file_pelatihan', $nama_file); //directori upload file
                $this->Model_pelatihan->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pelatihan'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pelatihan/edit' . $id_pelatihan));
        }
    }

    public function delete($id_pelatihan)
    {
        //menghapus foto lama
        $pelatihan = $this->Model_pelatihan->detail_data($id_pelatihan);
        if ($pelatihan['file_pelatihan'] != "") {
            unlink('file_pelatihan/' . $pelatihan['file_pelatihan']);
        }

        $data = array(
            'id_pelatihan' => $id_pelatihan,
        );
        $this->Model_pelatihan->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('pelatihan'));
    }

    public function viewpdf($id_pelatihan)
    {
        $data = array(
            'title' => 'View Document',
            'pelatihan' => $this->Model_pelatihan->detail_data($id_pelatihan),
            'isi'    => 'pelatihan/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
