<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_pelatihan extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_pelatihan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan.id_user', 'left')
            ->join('tbl_kategori_pelatihan', 'tbl_kategori_pelatihan.id_kategori_pelatihan = tbl_pelatihan.id_kategori_pelatihan', 'left')
            ->orderBy('id_pelatihan', 'DESC')
            ->where('tbl_pelatihan.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_pelatihan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan.id_user', 'left')
            ->join('tbl_kategori_pelatihan', 'tbl_kategori_pelatihan.id_kategori_pelatihan = tbl_pelatihan.id_kategori_pelatihan', 'left')
            ->orderBy('id_pelatihan', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_pelatihan)
    {
        return $this->db->table('tbl_pelatihan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan.id_user', 'left')
            ->join('tbl_kategori_pelatihan', 'tbl_kategori_pelatihan.id_kategori_pelatihan = tbl_pelatihan.id_kategori_pelatihan', 'left')
            ->where('id_pelatihan', $id_pelatihan)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_pelatihan')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_pelatihan')
            ->where('id_pelatihan', $data['id_pelatihan'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_pelatihan')
            ->where('id_pelatihan', $data['id_pelatihan'])
            ->delete($data);
    }
}
