<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_pelatihan_karyawan extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_pelatihan_karyawan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan_karyawan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan_karyawan.id_user', 'left')
            ->join('tbl_kategori_pelatihan_karyawan', 'tbl_kategori_pelatihan_karyawan.id_kategori_pelatihan_karyawan = tbl_pelatihan_karyawan.id_kategori_pelatihan_karyawan', 'left')
            ->orderBy('id_pelatihan_karyawan', 'DESC')
            ->where('tbl_pelatihan_karyawan.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_pelatihan_karyawan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan_karyawan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan_karyawan.id_user', 'left')
            ->join('tbl_kategori_pelatihan_karyawan', 'tbl_kategori_pelatihan_karyawan.id_kategori_pelatihan_karyawan = tbl_pelatihan_karyawan.id_kategori_pelatihan_karyawan', 'left')
            ->orderBy('id_pelatihan_karyawan', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_pelatihan_karyawan)
    {
        return $this->db->table('tbl_pelatihan_karyawan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan_karyawan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan_karyawan.id_user', 'left')
            ->join('tbl_kategori_pelatihan_karyawan', 'tbl_kategori_pelatihan_karyawan.id_kategori_pelatihan_karyawan = tbl_pelatihan_karyawan.id_kategori_pelatihan_karyawan', 'left')
            ->where('id_pelatihan_karyawan', $id_pelatihan_karyawan)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_pelatihan_karyawan')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_pelatihan_karyawan')
            ->where('id_pelatihan_karyawan', $data['id_pelatihan_karyawan'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_pelatihan_karyawan')
            ->where('id_pelatihan_karyawan', $data['id_pelatihan_karyawan'])
            ->delete($data);
    }
}
