<div class="row">
    <div class="col-md-12">
        <div class="box box-primary box-solid">
            <div class="box-header with-border">
                <h3 class="box-title">Data kategori_identitas</h3>

                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm btn-flat" data-toggle="modal" data-target="#add">
                        <?php if (session()->id_user == 1) : ?>
                            <i class="fa fa-plus"></i> Add</button>
                <?php endif; ?>
                </div>
                <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <?php
                if (session()->getFlashdata('pesan')) {
                    echo '<div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h4><i class="icon fa fa-check"></i> Success! - ';
                    echo session()->getFlashdata('pesan');
                    echo '</h4></div>';
                }
                ?>
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="80px">No</th>
                            <th>kategori_identitas</th>
                            <th width="100px"><?php if (session()->id_user == 1) : ?>Action <?php endif; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1;
                        foreach ($kategori_identitas as $key => $value) { ?>
                            <tr>
                                <td><?= $no++; ?></td>
                                <td><?= $value['nama_kategori_identitas']; ?></td>
                                <td class="text-center">
                                    <?php if (session()->id_user == 1) : ?>
                                        <button class="btn btn-xs btn-warning" data-toggle="modal" data-target="#edit<?= $value['id_kategori_identitas']; ?>">Edit</button>
                                        <button class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete<?= $value['id_kategori_identitas']; ?>">Delete</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>

            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </div>
</div>

<!-- /.modal add kategori_identitas -->
<div class="modal fade" id="add">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Add kategori_identitas</h4>
            </div>
            <div class="modal-body">
                <?php
                echo form_open('kategori_identitas/add')
                ?>

                <div class="form-group">
                    <label>kategori_identitas</label>
                    <input name="nama_kategori_identitas" class="form-control" placeholder="kategori_identitas" required>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
            <?php echo form_close() ?>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- end modal add kategori_identitas -->


<!-- /.modal edit kategori_identitas -->
<?php foreach ($kategori_identitas as $key => $value) { ?>
    <div class="modal fade" id="edit<?= $value['id_kategori_identitas']; ?>">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit kategori_identitas</h4>
                </div>
                <div class="modal-body">
                    <?php
                    echo form_open('kategori_identitas/edit/' . $value['id_kategori_identitas'])
                    ?>

                    <div class="form-group">
                        <label>kategori_identitas</label>
                        <input name="nama_kategori_identitas" value="<?= $value['nama_kategori_identitas']; ?>" class="form-control" placeholder="kategori_identitas" required>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
                <?php echo form_close() ?>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal edit kategori_identitas -->


<!-- /.modal delete kategori_identitas -->
<?php foreach ($kategori_identitas as $key => $value) { ?>
    <div class="modal fade" id="delete<?= $value['id_kategori_identitas']; ?>">
        <div class="modal-dialog modal-sm modal-danger">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Delete kategori_identitas</h4>
                </div>
                <div class="modal-body">

                    Apakah Anda Yakin Ingin Hapus <?= $value['nama_kategori_identitas']; ?>..?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Tidak</button>
                    <a href="<?= base_url('kategori_identitas/delete/' . $value['id_kategori_identitas']) ?>" type="submit" class="btn btn-primary">Ya</a>
                </div>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal delete kategori_identitas -->