<?php

namespace App\Controllers;

use App\Models\Model_biodata;
use App\Models\Model_agama;
use App\Models\Model_jenis_kelamin;
use App\Models\Model_status;

class biodata extends BaseController
{

    public function __construct()
    {
        $this->Model_biodata = new Model_biodata();
        $this->Model_agama = new Model_agama();
        $this->Model_jenis_kelamin = new Model_jenis_kelamin();
        $this->Model_status = new Model_status();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'biodata' => $this->Model_biodata->all_data(),
            'isi'    => 'biodata/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'agama' => $this->Model_agama->all_data(),
            'jenis_kelamin' => $this->Model_jenis_kelamin->all_data(),
            'status' => $this->Model_status->all_data(),
            'isi'    => 'biodata/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_lengkap' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'nik' => [
                'label'  => 'Isi NIK',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'tempat_tanggal' => [
                'label'  => 'Isi TTL',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_agama' => [
                'label'  => 'agama',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'id_jenis_kelamin' => [
                'label'  => 'jenis_kelamin',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'id_status' => [
                'label'  => 'status',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'tmt' => [
                'label'  => 'tmt',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'no_sk_tmt' => [
                'label'  => 'no_sk_tmt',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //jika valid
            $data = array(
                'id_agama' => $this->request->getPost('id_agama'),
                'id_jenis_kelamin' => $this->request->getPost('id_jenis_kelamin'),
                'id_status' => $this->request->getPost('id_status'),
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                'tmt' => $this->request->getPost('tmt'),
                'no_sk_tmt' => $this->request->getPost('no_sk_tmt'),
                'nik' => $this->request->getPost('nik'),
                'tempat_tanggal' => $this->request->getPost('tempat_tanggal'),
                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
            );

            $this->Model_biodata->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('biodata'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('biodata/add'));
        }
    }

    //edit
    public function edit($id_biodata)
    {
        $data = array(
            'title' => 'Edit Document',
            'agama' => $this->Model_agama->all_data(),
            'jenis_kelamin' => $this->Model_jenis_kelamin->all_data(),
            'status' => $this->Model_status->all_data(),
            'biodata'    => $this->Model_biodata->detail_data($id_biodata),
            'isi'    => 'biodata/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_biodata)
    {
        if ($this->validate([
            'nama_lengkap' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'nik' => [
                'label'  => 'Isi NIK',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'tempat_tanggal' => [
                'label'  => 'Isi TTL',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_agama' => [
                'label'  => 'agama',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'id_jenis_kelamin' => [
                'label'  => 'jenis_kelamin',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'id_status' => [
                'label'  => 'status',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'tmt' => [
                'label'  => 'tmt',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
            'no_sk_tmt' => [
                'label'  => 'no_sk_tmt',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //jika valid
            $data = array(
                'id_biodata'  => $id_biodata,
                'id_agama' => $this->request->getPost('id_agama'),
                'id_jenis_kelamin' => $this->request->getPost('id_jenis_kelamin'),
                'id_status' => $this->request->getPost('id_status'),
                'nama_lengkap' => $this->request->getPost('nama_lengkap'),
                'tmt' => $this->request->getPost('tmt'),
                'no_sk_tmt' => $this->request->getPost('no_sk_tmt'),
                'nik' => $this->request->getPost('nik'),
                'tempat_tanggal' => $this->request->getPost('tempat_tanggal'),
                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
            );

            $this->Model_biodata->edit($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('biodata'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('biodata/edit'));
        }
    }

    public function delete($id_biodata)
    {
        //menghapus foto lama
        $biodata = $this->Model_biodata->detail_data($id_biodata);
        $data = array(
            'id_biodata' => $id_biodata,
        );
        $this->Model_biodata->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('biodata'));
    }

    public function viewpdf($id_biodata)
    {
        $data = array(
            'title' => 'View Document',
            'biodata' => $this->Model_biodata->detail_data($id_biodata),
            'isi'    => 'biodata/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
