<?php

namespace App\Controllers;

use App\Models\Model_pendidikan;
use App\Models\Model_kategori_pendidikan;

class pendidikan extends BaseController
{

    public function __construct()
    {
        $this->Model_pendidikan = new Model_pendidikan();
        $this->Model_kategori_pendidikan = new Model_kategori_pendidikan();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'pendidikan' => $this->Model_pendidikan->all_data(),
            'isi'    => 'pendidikan/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_pendidikan' => $this->Model_kategori_pendidikan->all_data(),
            'isi'    => 'pendidikan/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_pendidikan' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_pendidikan' => [
                'label'  => 'kategori_pendidikan',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pendidikan = $this->request->getFile('file_pendidikan');
            //merandom nama file foto
            $nama_file = $file_pendidikan->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_pendidikan->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_pendidikan' => $this->request->getPost('id_kategori_pendidikan'),
                'nama_pendidikan' => $this->request->getPost('nama_pendidikan'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_pendidikan' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_pendidikan->move('file_pendidikan', $nama_file); //directori upload file
            $this->Model_pendidikan->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pendidikan'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pendidikan/add'));
        }
    }

    //edit
    public function edit($id_pendidikan)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_pendidikan' => $this->Model_kategori_pendidikan->all_data(),
            'pendidikan'    => $this->Model_pendidikan->detail_data($id_pendidikan),
            'isi'    => 'pendidikan/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_pendidikan)
    {
        if ($this->validate([
            'nama_pendidikan' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_pendidikan' => [
                'label'  => 'kategori_pendidikan',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pendidikan = $this->request->getFile('file_pendidikan');
            if ($file_pendidikan->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_pendidikan'  => $id_pendidikan,
                    'id_kategori_pendidikan' => $this->request->getPost('id_kategori_pendidikan'),
                    'nama_pendidikan' => $this->request->getPost('nama_pendidikan'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_pendidikan->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $pendidikan = $this->Model_pendidikan->detail_data($id_pendidikan);
                if ($pendidikan['file_pendidikan'] != "") {
                    unlink('file_pendidikan/' . $pendidikan['file_pendidikan']);
                }
                //merandom nama file foto
                $nama_file = $file_pendidikan->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_pendidikan->getSize('kb');
                //jika valid
                $data = array(
                    'id_pendidikan'  => $id_pendidikan,
                    'id_kategori_pendidikan' => $this->request->getPost('id_kategori_pendidikan'),
                    'nama_pendidikan' => $this->request->getPost('nama_pendidikan'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_pendidikan' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_pendidikan->move('file_pendidikan', $nama_file); //directori upload file
                $this->Model_pendidikan->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pendidikan'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pendidikan/edit' . $id_pendidikan));
        }
    }

    public function delete($id_pendidikan)
    {
        //menghapus foto lama
        $pendidikan = $this->Model_pendidikan->detail_data($id_pendidikan);
        if ($pendidikan['file_pendidikan'] != "") {
            unlink('file_pendidikan/' . $pendidikan['file_pendidikan']);
        }

        $data = array(
            'id_pendidikan' => $id_pendidikan,
        );
        $this->Model_pendidikan->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('pendidikan'));
    }

    public function viewpdf($id_pendidikan)
    {
        $data = array(
            'title' => 'View Document',
            'pendidikan' => $this->Model_pendidikan->detail_data($id_pendidikan),
            'isi'    => 'pendidikan/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
