<?php

namespace App\Controllers;

use App\Models\Model_agama;

class Agama extends BaseController
{

    public function __construct()
    {
        $this->Model_agama = new Model_agama();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Agama   ',
            'agama' => $this->Model_agama->all_data(),
            'isi'    => 'v_agama'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array('nama_agama' => $this->request->getPost('nama_agama'));
        $this->Model_agama->add($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
        return redirect()->to(base_url('agama'));
    }

    public function edit($id_agama)
    {
        $data = array(
            'id_agama' => $id_agama,
            'nama_agama' => $this->request->getPost('nama_agama'),
        );
        $this->Model_agama->edit($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Update !!!');
        return redirect()->to(base_url('agama'));
    }

    public function delete($id_agama)
    {
        $data = array(
            'id_agama' => $id_agama,
        );
        $this->Model_agama->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('agama'));
    }
    //--------------------------------------------------------------------

}
