<?php

namespace App\Controllers;

use App\Models\Model_pelatihan_karyawan;
use App\Models\Model_kategori_pelatihan_karyawan;

class pelatihan_karyawan extends BaseController
{

    public function __construct()
    {
        $this->Model_pelatihan_karyawan = new Model_pelatihan_karyawan();
        $this->Model_kategori_pelatihan_karyawan = new Model_kategori_pelatihan_karyawan();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'pelatihan_karyawan' => $this->Model_pelatihan_karyawan->all_data(),
            'isi'    => 'pelatihan_karyawan/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_pelatihan_karyawan' => $this->Model_kategori_pelatihan_karyawan->all_data(),
            'isi'    => 'pelatihan_karyawan/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_pelatihan_karyawan' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_pelatihan_karyawan' => [
                'label'  => 'kategori_pelatihan_karyawan',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pelatihan_karyawan = $this->request->getFile('file_pelatihan_karyawan');
            //merandom nama file foto
            $nama_file = $file_pelatihan_karyawan->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_pelatihan_karyawan->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_pelatihan_karyawan' => $this->request->getPost('id_kategori_pelatihan_karyawan'),
                'nama_pelatihan_karyawan' => $this->request->getPost('nama_pelatihan_karyawan'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_pelatihan_karyawan' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_pelatihan_karyawan->move('file_pelatihan_karyawan', $nama_file); //directori upload file
            $this->Model_pelatihan_karyawan->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pelatihan_karyawan'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pelatihan_karyawan/add'));
        }
    }

    //edit
    public function edit($id_pelatihan_karyawan)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_pelatihan_karyawan' => $this->Model_kategori_pelatihan_karyawan->all_data(),
            'pelatihan_karyawan'    => $this->Model_pelatihan_karyawan->detail_data($id_pelatihan_karyawan),
            'isi'    => 'pelatihan_karyawan/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_pelatihan_karyawan)
    {
        if ($this->validate([
            'nama_pelatihan_karyawan' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_pelatihan_karyawan' => [
                'label'  => 'kategori_pelatihan_karyawan',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pelatihan_karyawan = $this->request->getFile('file_pelatihan_karyawan');
            if ($file_pelatihan_karyawan->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_pelatihan_karyawan'  => $id_pelatihan_karyawan,
                    'id_kategori_pelatihan_karyawan' => $this->request->getPost('id_kategori_pelatihan_karyawan'),
                    'nama_pelatihan_karyawan' => $this->request->getPost('nama_pelatihan_karyawan'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_pelatihan_karyawan->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $pelatihan_karyawan = $this->Model_pelatihan_karyawan->detail_data($id_pelatihan_karyawan);
                if ($pelatihan_karyawan['file_pelatihan_karyawan'] != "") {
                    unlink('file_pelatihan_karyawan/' . $pelatihan_karyawan['file_pelatihan_karyawan']);
                }
                //merandom nama file foto
                $nama_file = $file_pelatihan_karyawan->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_pelatihan_karyawan->getSize('kb');
                //jika valid
                $data = array(
                    'id_pelatihan_karyawan'  => $id_pelatihan_karyawan,
                    'id_kategori_pelatihan_karyawan' => $this->request->getPost('id_kategori_pelatihan_karyawan'),
                    'nama_pelatihan_karyawan' => $this->request->getPost('nama_pelatihan_karyawan'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_pelatihan_karyawan' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_pelatihan_karyawan->move('file_pelatihan_karyawan', $nama_file); //directori upload file
                $this->Model_pelatihan_karyawan->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pelatihan_karyawan'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pelatihan_karyawan/edit' . $id_pelatihan_karyawan));
        }
    }

    public function delete($id_pelatihan_karyawan)
    {
        //menghapus foto lama
        $pelatihan_karyawan = $this->Model_pelatihan_karyawan->detail_data($id_pelatihan_karyawan);
        if ($pelatihan_karyawan['file_pelatihan_karyawan'] != "") {
            unlink('file_pelatihan_karyawan/' . $pelatihan_karyawan['file_pelatihan_karyawan']);
        }

        $data = array(
            'id_pelatihan_karyawan' => $id_pelatihan_karyawan,
        );
        $this->Model_pelatihan_karyawan->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('pelatihan_karyawan'));
    }

    public function viewpdf($id_pelatihan_karyawan)
    {
        $data = array(
            'title' => 'View Document',
            'pelatihan_karyawan' => $this->Model_pelatihan_karyawan->detail_data($id_pelatihan_karyawan),
            'isi'    => 'pelatihan_karyawan/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
