<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_mengajar extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_mengajar')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_mengajar.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_mengajar.id_user', 'left')
            ->join('tbl_kategori_mengajar', 'tbl_kategori_mengajar.id_kategori_mengajar = tbl_mengajar.id_kategori_mengajar', 'left')
            ->orderBy('id_mengajar', 'DESC')
            ->where('tbl_mengajar.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_mengajar')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_mengajar.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_mengajar.id_user', 'left')
            ->join('tbl_kategori_mengajar', 'tbl_kategori_mengajar.id_kategori_mengajar = tbl_mengajar.id_kategori_mengajar', 'left')
            ->orderBy('id_mengajar', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_mengajar)
    {
        return $this->db->table('tbl_mengajar')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_mengajar.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_mengajar.id_user', 'left')
            ->join('tbl_kategori_mengajar', 'tbl_kategori_mengajar.id_kategori_mengajar = tbl_mengajar.id_kategori_mengajar', 'left')
            ->where('id_mengajar', $id_mengajar)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_mengajar')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_mengajar')
            ->where('id_mengajar', $data['id_mengajar'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_mengajar')
            ->where('id_mengajar', $data['id_mengajar'])
            ->delete($data);
    }
}
