<?php

namespace App\Controllers;

use App\Models\Model_identitas;
use App\Models\Model_kategori_identitas;

class identitas extends BaseController
{

    public function __construct()
    {
        $this->Model_identitas = new Model_identitas();
        $this->Model_kategori_identitas = new Model_kategori_identitas();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'identitas' => $this->Model_identitas->all_data(),
            'isi'    => 'identitas/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_identitas' => $this->Model_kategori_identitas->all_data(),
            'isi'    => 'identitas/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_identitas' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_identitas' => [
                'label'  => 'kategori_identitas',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_identitas = $this->request->getFile('file_identitas');
            //merandom nama file foto
            $nama_file = $file_identitas->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_identitas->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_identitas' => $this->request->getPost('id_kategori_identitas'),
                'nama_identitas' => $this->request->getPost('nama_identitas'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_identitas' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_identitas->move('file_identitas', $nama_file); //directori upload file
            $this->Model_identitas->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('identitas'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('identitas/add'));
        }
    }

    //edit
    public function edit($id_identitas)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_identitas' => $this->Model_kategori_identitas->all_data(),
            'identitas'    => $this->Model_identitas->detail_data($id_identitas),
            'isi'    => 'identitas/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_identitas)
    {
        if ($this->validate([
            'nama_identitas' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_identitas' => [
                'label'  => 'kategori_identitas',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_identitas = $this->request->getFile('file_identitas');
            if ($file_identitas->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_identitas'  => $id_identitas,
                    'id_kategori_identitas' => $this->request->getPost('id_kategori_identitas'),
                    'nama_identitas' => $this->request->getPost('nama_identitas'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_identitas->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $identitas = $this->Model_identitas->detail_data($id_identitas);
                if ($identitas['file_identitas'] != "") {
                    unlink('file_identitas/' . $identitas['file_identitas']);
                }
                //merandom nama file foto
                $nama_file = $file_identitas->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_identitas->getSize('kb');
                //jika valid
                $data = array(
                    'id_identitas'  => $id_identitas,
                    'id_kategori_identitas' => $this->request->getPost('id_kategori_identitas'),
                    'nama_identitas' => $this->request->getPost('nama_identitas'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_identitas' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_identitas->move('file_identitas', $nama_file); //directori upload file
                $this->Model_identitas->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('identitas'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('identitas/edit' . $id_identitas));
        }
    }

    public function delete($id_identitas)
    {
        //menghapus foto lama
        $identitas = $this->Model_identitas->detail_data($id_identitas);
        if ($identitas['file_identitas'] != "") {
            unlink('file_identitas/' . $identitas['file_identitas']);
        }

        $data = array(
            'id_identitas' => $id_identitas,
        );
        $this->Model_identitas->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('identitas'));
    }

    public function viewpdf($id_identitas)
    {
        $data = array(
            'title' => 'View Document',
            'identitas' => $this->Model_identitas->detail_data($id_identitas),
            'isi'    => 'identitas/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
