<?php

namespace App\Controllers;

use App\Models\Model_mengajar;
use App\Models\Model_kategori_mengajar;

class mengajar extends BaseController
{

    public function __construct()
    {
        $this->Model_mengajar = new Model_mengajar();
        $this->Model_kategori_mengajar = new Model_kategori_mengajar();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'mengajar' => $this->Model_mengajar->all_data(),
            'isi'    => 'mengajar/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_mengajar' => $this->Model_kategori_mengajar->all_data(),
            'isi'    => 'mengajar/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_mengajar' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_mengajar' => [
                'label'  => 'kategori_mengajar',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_mengajar = $this->request->getFile('file_mengajar');
            //merandom nama file foto
            $nama_file = $file_mengajar->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_mengajar->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_mengajar' => $this->request->getPost('id_kategori_mengajar'),
                'nama_mengajar' => $this->request->getPost('nama_mengajar'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_mengajar' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_mengajar->move('file_mengajar', $nama_file); //directori upload file
            $this->Model_mengajar->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('mengajar'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('mengajar/add'));
        }
    }

    //edit
    public function edit($id_mengajar)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_mengajar' => $this->Model_kategori_mengajar->all_data(),
            'mengajar'    => $this->Model_mengajar->detail_data($id_mengajar),
            'isi'    => 'mengajar/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_mengajar)
    {
        if ($this->validate([
            'nama_mengajar' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_mengajar' => [
                'label'  => 'kategori_mengajar',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_mengajar = $this->request->getFile('file_mengajar');
            if ($file_mengajar->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_mengajar'  => $id_mengajar,
                    'id_kategori_mengajar' => $this->request->getPost('id_kategori_mengajar'),
                    'nama_mengajar' => $this->request->getPost('nama_mengajar'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_mengajar->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $mengajar = $this->Model_mengajar->detail_data($id_mengajar);
                if ($mengajar['file_mengajar'] != "") {
                    unlink('file_mengajar/' . $mengajar['file_mengajar']);
                }
                //merandom nama file foto
                $nama_file = $file_mengajar->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_mengajar->getSize('kb');
                //jika valid
                $data = array(
                    'id_mengajar'  => $id_mengajar,
                    'id_kategori_mengajar' => $this->request->getPost('id_kategori_mengajar'),
                    'nama_mengajar' => $this->request->getPost('nama_mengajar'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_mengajar' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_mengajar->move('file_mengajar', $nama_file); //directori upload file
                $this->Model_mengajar->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('mengajar'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('mengajar/edit' . $id_mengajar));
        }
    }

    public function delete($id_mengajar)
    {
        //menghapus foto lama
        $mengajar = $this->Model_mengajar->detail_data($id_mengajar);
        if ($mengajar['file_mengajar'] != "") {
            unlink('file_mengajar/' . $mengajar['file_mengajar']);
        }

        $data = array(
            'id_mengajar' => $id_mengajar,
        );
        $this->Model_mengajar->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('mengajar'));
    }

    public function viewpdf($id_mengajar)
    {
        $data = array(
            'title' => 'View Document',
            'mengajar' => $this->Model_mengajar->detail_data($id_mengajar),
            'isi'    => 'mengajar/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
