<?php

namespace App\Controllers;

use App\Models\Model_mengajar_guru;
use App\Models\Model_kategori_mengajar_guru;

class mengajar_guru extends BaseController
{

    public function __construct()
    {
        $this->Model_mengajar_guru = new Model_mengajar_guru();
        $this->Model_kategori_mengajar_guru = new Model_kategori_mengajar_guru();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'mengajar_guru' => $this->Model_mengajar_guru->all_data(),
            'isi'    => 'mengajar_guru/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_mengajar_guru' => $this->Model_kategori_mengajar_guru->all_data(),
            'isi'    => 'mengajar_guru/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_mengajar_guru' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_mengajar_guru' => [
                'label'  => 'kategori_mengajar_guru',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_mengajar_guru = $this->request->getFile('file_mengajar_guru');
            //merandom nama file foto
            $nama_file = $file_mengajar_guru->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_mengajar_guru->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_mengajar_guru' => $this->request->getPost('id_kategori_mengajar_guru'),
                'nama_mengajar_guru' => $this->request->getPost('nama_mengajar_guru'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_mengajar_guru' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_mengajar_guru->move('file_mengajar_guru', $nama_file); //directori upload file
            $this->Model_mengajar_guru->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('mengajar_guru'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('mengajar_guru/add'));
        }
    }

    //edit
    public function edit($id_mengajar_guru)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_mengajar_guru' => $this->Model_kategori_mengajar_guru->all_data(),
            'mengajar_guru'    => $this->Model_mengajar_guru->detail_data($id_mengajar_guru),
            'isi'    => 'mengajar_guru/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_mengajar_guru)
    {
        if ($this->validate([
            'nama_mengajar_guru' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_mengajar_guru' => [
                'label'  => 'kategori_mengajar_guru',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_mengajar_guru = $this->request->getFile('file_mengajar_guru');
            if ($file_mengajar_guru->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_mengajar_guru'  => $id_mengajar_guru,
                    'id_kategori_mengajar_guru' => $this->request->getPost('id_kategori_mengajar_guru'),
                    'nama_mengajar_guru' => $this->request->getPost('nama_mengajar_guru'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_mengajar_guru->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $mengajar_guru = $this->Model_mengajar_guru->detail_data($id_mengajar_guru);
                if ($mengajar_guru['file_mengajar_guru'] != "") {
                    unlink('file_mengajar_guru/' . $mengajar_guru['file_mengajar_guru']);
                }
                //merandom nama file foto
                $nama_file = $file_mengajar_guru->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_mengajar_guru->getSize('kb');
                //jika valid
                $data = array(
                    'id_mengajar_guru'  => $id_mengajar_guru,
                    'id_kategori_mengajar_guru' => $this->request->getPost('id_kategori_mengajar_guru'),
                    'nama_mengajar_guru' => $this->request->getPost('nama_mengajar_guru'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_mengajar_guru' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_mengajar_guru->move('file_mengajar_guru', $nama_file); //directori upload file
                $this->Model_mengajar_guru->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('mengajar_guru'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('mengajar_guru/edit' . $id_mengajar_guru));
        }
    }

    public function delete($id_mengajar_guru)
    {
        //menghapus foto lama
        $mengajar_guru = $this->Model_mengajar_guru->detail_data($id_mengajar_guru);
        if ($mengajar_guru['file_mengajar_guru'] != "") {
            unlink('file_mengajar_guru/' . $mengajar_guru['file_mengajar_guru']);
        }

        $data = array(
            'id_mengajar_guru' => $id_mengajar_guru,
        );
        $this->Model_mengajar_guru->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('mengajar_guru'));
    }

    public function viewpdf($id_mengajar_guru)
    {
        $data = array(
            'title' => 'View Document',
            'mengajar_guru' => $this->Model_mengajar_guru->detail_data($id_mengajar_guru),
            'isi'    => 'mengajar_guru/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
