<?php

namespace App\Controllers;

use App\Models\Model_pelatihan_guru;
use App\Models\Model_kategori_tingkat;

class pelatihan_guru extends BaseController
{

    public function __construct()
    {
        $this->Model_pelatihan_guru = new Model_pelatihan_guru();
        $this->Model_kategori_tingkat = new Model_kategori_tingkat();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'pelatihan_guru' => $this->Model_pelatihan_guru->all_data(),
            'isi'    => 'pelatihan_guru/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_tingkat' => $this->Model_kategori_tingkat->all_data(),
            'isi'    => 'pelatihan_guru/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_pelatihan_guru' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_tingkat' => [
                'label'  => 'kategori_tingkat',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pelatihan_guru = $this->request->getFile('file_pelatihan_guru');
            //merandom nama file foto
            $nama_file = $file_pelatihan_guru->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_pelatihan_guru->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_tingkat' => $this->request->getPost('id_kategori_tingkat'),
                'nama_pelatihan_guru' => $this->request->getPost('nama_pelatihan_guru'),
                'penyelenggara' => $this->request->getPost('penyelenggara'),
                'jumlah_jam' => $this->request->getPost('jumlah_jam'),
                'tahun' => $this->request->getPost('tahun'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_pelatihan_guru' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_pelatihan_guru->move('file_pelatihan_guru', $nama_file); //directori upload file
            $this->Model_pelatihan_guru->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pelatihan_guru'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pelatihan_guru/add'));
        }
    }

    //edit
    public function edit($id_pelatihan_guru)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_tingkat' => $this->Model_kategori_tingkat->all_data(),
            'pelatihan_guru'    => $this->Model_pelatihan_guru->detail_data($id_pelatihan_guru),
            'isi'    => 'pelatihan_guru/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_pelatihan_guru)
    {
        if ($this->validate([
            'nama_pelatihan_guru' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_tingkat' => [
                'label'  => 'kategori_tingkat',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_pelatihan_guru = $this->request->getFile('file_pelatihan_guru');
            if ($file_pelatihan_guru->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_pelatihan_guru'  => $id_pelatihan_guru,
                    'id_kategori_tingkat' => $this->request->getPost('id_kategori_tingkat'),
                    'nama_pelatihan_guru' => $this->request->getPost('nama_pelatihan_guru'),
                    'penyelenggara' => $this->request->getPost('penyelenggara'),
                    'jumlah_jam' => $this->request->getPost('jumlah_jam'),
                    'tahun' => $this->request->getPost('tahun'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_pelatihan_guru->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $pelatihan_guru = $this->Model_pelatihan_guru->detail_data($id_pelatihan_guru);
                if ($pelatihan_guru['file_pelatihan_guru'] != "") {
                    unlink('file_pelatihan_guru/' . $pelatihan_guru['file_pelatihan_guru']);
                }
                //merandom nama file foto
                $nama_file = $file_pelatihan_guru->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_pelatihan_guru->getSize('kb');
                //jika valid
                $data = array(
                    'id_pelatihan_guru'  => $id_pelatihan_guru,
                    'id_kategori_tingkat' => $this->request->getPost('id_kategori_tingkat'),
                    'nama_pelatihan_guru' => $this->request->getPost('nama_pelatihan_guru'),
                    'penyelenggara' => $this->request->getPost('penyelenggara'),
                    'jumlah_jam' => $this->request->getPost('jumlah_jam'),
                    'tahun' => $this->request->getPost('tahun'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_pelatihan_guru' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_pelatihan_guru->move('file_pelatihan_guru', $nama_file); //directori upload file
                $this->Model_pelatihan_guru->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('pelatihan_guru'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('pelatihan_guru/edit' . $id_pelatihan_guru));
        }
    }

    public function delete($id_pelatihan_guru)
    {
        //menghapus foto lama
        $pelatihan_guru = $this->Model_pelatihan_guru->detail_data($id_pelatihan_guru);
        if ($pelatihan_guru['file_pelatihan_guru'] != "") {
            unlink('file_pelatihan_guru/' . $pelatihan_guru['file_pelatihan_guru']);
        }

        $data = array(
            'id_pelatihan_guru' => $id_pelatihan_guru,
        );
        $this->Model_pelatihan_guru->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('pelatihan_guru'));
    }

    public function viewpdf($id_pelatihan_guru)
    {
        $data = array(
            'title' => 'View Document',
            'pelatihan_guru' => $this->Model_pelatihan_guru->detail_data($id_pelatihan_guru),
            'isi'    => 'pelatihan_guru/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
