<?php

namespace App\Controllers;

use App\Models\Model_tugas;
use App\Models\Model_kategori_tugas;

class tugas extends BaseController
{

    public function __construct()
    {
        $this->Model_tugas = new Model_tugas();
        $this->Model_kategori_tugas = new Model_kategori_tugas();
        helper('form');
    }

    public function index()
    {
        $data = array(
            'title' => 'Document',
            'tugas' => $this->Model_tugas->all_data(),
            'isi'    => 'tugas/v_index'
        );
        return view('layout/v_wrapper', $data);
    }

    public function add()
    {
        $data = array(
            'title' => 'Add Document',
            'kategori_tugas' => $this->Model_kategori_tugas->all_data(),
            'isi'    => 'tugas/v_add'
        );
        return view('layout/v_wrapper', $data);
    }
    //--------------------------------------------------------------------

    public function insert()
    {
        if ($this->validate([
            'nama_tugas' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_tugas' => [
                'label'  => 'kategori_tugas',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],
        ])) {
            //mengambil file foto yg akan di upload di form
            $file_tugas = $this->request->getFile('file_tugas');
            //merandom nama file foto
            $nama_file = $file_tugas->getRandomName();
            //mengambil ukuran file
            $ukuran_file = $file_tugas->getSize('kb');
            //jika valid
            $data = array(
                'id_kategori_tugas' => $this->request->getPost('id_kategori_tugas'),
                'nama_tugas' => $this->request->getPost('nama_tugas'),

                'tgl_upload' => date('Y-m-d'),
                'tgl_update' => date('Y-m-d'),
                'id_dep' => session()->get('id_dep'),
                'id_user' => session()->get('id_user'),
                'file_tugas' => $nama_file,
                'ukuran_file' => $ukuran_file,
            );

            $file_tugas->move('file_tugas', $nama_file); //directori upload file
            $this->Model_tugas->add($data);
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('tugas'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('tugas/add'));
        }
    }

    //edit
    public function edit($id_tugas)
    {
        $data = array(
            'title' => 'Edit Document',
            'kategori_tugas' => $this->Model_kategori_tugas->all_data(),
            'tugas'    => $this->Model_tugas->detail_data($id_tugas),
            'isi'    => 'tugas/v_edit'
        );
        return view('layout/v_wrapper', $data);
    }

    public function update($id_tugas)
    {
        if ($this->validate([
            'nama_tugas' => [
                'label'  => 'Nama Document',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!'
                ]
            ],
            'id_kategori_tugas' => [
                'label'  => 'kategori_tugas',
                'rules'  => 'required',
                'errors' => [
                    'required' => '{field} Wajib Diisi !!!',
                ]
            ],

        ])) {
            //mengambil file foto yg akan di upload di form
            $file_tugas = $this->request->getFile('file_tugas');
            if ($file_tugas->getError() == 4) {
                //jika file tidak di ganti
                $data = array(
                    'id_tugas'  => $id_tugas,
                    'id_kategori_tugas' => $this->request->getPost('id_kategori_tugas'),
                    'nama_tugas' => $this->request->getPost('nama_tugas'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                );
                $this->Model_tugas->edit($data);
            } else {
                //jika file di ganti
                //menghapus foto lama
                $tugas = $this->Model_tugas->detail_data($id_tugas);
                if ($tugas['file_tugas'] != "") {
                    unlink('file_tugas/' . $tugas['file_tugas']);
                }
                //merandom nama file foto
                $nama_file = $file_tugas->getRandomName();
                //mengambil ukuran file
                $ukuran_file = $file_tugas->getSize('kb');
                //jika valid
                $data = array(
                    'id_tugas'  => $id_tugas,
                    'id_kategori_tugas' => $this->request->getPost('id_kategori_tugas'),
                    'nama_tugas' => $this->request->getPost('nama_tugas'),
                    'tgl_update' => date('Y-m-d'),
                    'id_dep' => session()->get('id_dep'),
                    'id_user' => session()->get('id_user'),
                    'file_tugas' => $nama_file,
                    'ukuran_file' => $ukuran_file,
                );
                $file_tugas->move('file_tugas', $nama_file); //directori upload file
                $this->Model_tugas->edit($data);
            }
            session()->setFlashdata('pesan', 'Data Berhasil Di Tambahkan !!!');
            return redirect()->to(base_url('tugas'));
        } else {
            //jika Tidak valid
            session()->setFlashdata('errors', \Config\Services::validation()->getErrors());
            return redirect()->to(base_url('tugas/edit' . $id_tugas));
        }
    }

    public function delete($id_tugas)
    {
        //menghapus foto lama
        $tugas = $this->Model_tugas->detail_data($id_tugas);
        if ($tugas['file_tugas'] != "") {
            unlink('file_tugas/' . $tugas['file_tugas']);
        }

        $data = array(
            'id_tugas' => $id_tugas,
        );
        $this->Model_tugas->delete_data($data);
        session()->setFlashdata('pesan', 'Data Berhasil Di Hapus !!!');
        return redirect()->to(base_url('tugas'));
    }

    public function viewpdf($id_tugas)
    {
        $data = array(
            'title' => 'View Document',
            'tugas' => $this->Model_tugas->detail_data($id_tugas),
            'isi'    => 'tugas/v_viewpdf'
        );
        return view('layout/v_wrapper', $data);
    }
}
