<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_biodata extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_biodata')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_biodata.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_biodata.id_user', 'left')
            ->join('tbl_agama', 'tbl_agama.id_agama = tbl_biodata.id_agama', 'left')
            ->join('tbl_jenis_kelamin', 'tbl_jenis_kelamin.id_jenis_kelamin = tbl_biodata.id_jenis_kelamin', 'left')
            ->join('tbl_status', 'tbl_status.id_status = tbl_biodata.id_status', 'left')
            ->orderBy('id_biodata', 'DESC')
            ->where('tbl_biodata.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_biodata')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_biodata.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_biodata.id_user', 'left')
            ->join('tbl_agama', 'tbl_agama.id_agama = tbl_biodata.id_agama', 'left')
            ->join('tbl_jenis_kelamin', 'tbl_jenis_kelamin.id_jenis_kelamin = tbl_biodata.id_jenis_kelamin', 'left')
            ->join('tbl_status', 'tbl_status.id_status = tbl_biodata.id_status', 'left')
            ->orderBy('id_biodata', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_biodata)
    {
        return $this->db->table('tbl_biodata')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_biodata.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_biodata.id_user', 'left')
            ->join('tbl_agama', 'tbl_agama.id_agama = tbl_biodata.id_agama', 'left')
            ->join('tbl_jenis_kelamin', 'tbl_jenis_kelamin.id_jenis_kelamin = tbl_biodata.id_jenis_kelamin', 'left')
            ->join('tbl_status', 'tbl_status.id_status = tbl_biodata.id_status', 'left')
            ->where('id_biodata', $id_biodata)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_biodata')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_biodata')
            ->where('id_biodata', $data['id_biodata'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_biodata')
            ->where('id_biodata', $data['id_biodata'])
            ->delete($data);
    }
}
