<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_mengajar_guru extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_mengajar_guru')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_mengajar_guru.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_mengajar_guru.id_user', 'left')
            ->join('tbl_kategori_mengajar_guru', 'tbl_kategori_mengajar_guru.id_kategori_mengajar_guru = tbl_mengajar_guru.id_kategori_mengajar_guru', 'left')
            ->orderBy('id_mengajar_guru', 'DESC')
            ->where('tbl_mengajar_guru.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_mengajar_guru')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_mengajar_guru.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_mengajar_guru.id_user', 'left')
            ->join('tbl_kategori_mengajar_guru', 'tbl_kategori_mengajar_guru.id_kategori_mengajar_guru = tbl_mengajar_guru.id_kategori_mengajar_guru', 'left')
            ->orderBy('id_mengajar_guru', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_mengajar_guru)
    {
        return $this->db->table('tbl_mengajar_guru')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_mengajar_guru.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_mengajar_guru.id_user', 'left')
            ->join('tbl_kategori_mengajar_guru', 'tbl_kategori_mengajar_guru.id_kategori_mengajar_guru = tbl_mengajar_guru.id_kategori_mengajar_guru', 'left')
            ->where('id_mengajar_guru', $id_mengajar_guru)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_mengajar_guru')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_mengajar_guru')
            ->where('id_mengajar_guru', $data['id_mengajar_guru'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_mengajar_guru')
            ->where('id_mengajar_guru', $data['id_mengajar_guru'])
            ->delete($data);
    }
}
