<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_pelatihan_guru extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_pelatihan_guru')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan_guru.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan_guru.id_user', 'left')
            ->join('tbl_kategori_tingkat', 'tbl_kategori_tingkat.id_kategori_tingkat = tbl_pelatihan_guru.id_kategori_tingkat', 'left')
            ->orderBy('id_pelatihan_guru', 'DESC')
            ->where('tbl_pelatihan_guru.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_pelatihan_guru')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan_guru.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan_guru.id_user', 'left')
            ->join('tbl_kategori_tingkat', 'tbl_kategori_tingkat.id_kategori_tingkat = tbl_pelatihan_guru.id_kategori_tingkat', 'left')
            ->orderBy('id_pelatihan_guru', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_pelatihan_guru)
    {
        return $this->db->table('tbl_pelatihan_guru')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pelatihan_guru.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pelatihan_guru.id_user', 'left')
            ->join('tbl_kategori_tingkat', 'tbl_kategori_tingkat.id_kategori_tingkat = tbl_pelatihan_guru.id_kategori_tingkat', 'left')
            ->where('id_pelatihan_guru', $id_pelatihan_guru)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_pelatihan_guru')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_pelatihan_guru')
            ->where('id_pelatihan_guru', $data['id_pelatihan_guru'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_pelatihan_guru')
            ->where('id_pelatihan_guru', $data['id_pelatihan_guru'])
            ->delete($data);
    }
}
