<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_pendidikan extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_pendidikan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pendidikan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pendidikan.id_user', 'left')
            ->join('tbl_kategori_pendidikan', 'tbl_kategori_pendidikan.id_kategori_pendidikan = tbl_pendidikan.id_kategori_pendidikan', 'left')
            ->orderBy('id_pendidikan', 'DESC')
            ->where('tbl_pendidikan.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_pendidikan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pendidikan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pendidikan.id_user', 'left')
            ->join('tbl_kategori_pendidikan', 'tbl_kategori_pendidikan.id_kategori_pendidikan = tbl_pendidikan.id_kategori_pendidikan', 'left')
            ->orderBy('id_pendidikan', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_pendidikan)
    {
        return $this->db->table('tbl_pendidikan')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_pendidikan.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_pendidikan.id_user', 'left')
            ->join('tbl_kategori_pendidikan', 'tbl_kategori_pendidikan.id_kategori_pendidikan = tbl_pendidikan.id_kategori_pendidikan', 'left')
            ->where('id_pendidikan', $id_pendidikan)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_pendidikan')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_pendidikan')
            ->where('id_pendidikan', $data['id_pendidikan'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_pendidikan')
            ->where('id_pendidikan', $data['id_pendidikan'])
            ->delete($data);
    }
}
