<?php

namespace App\Models;

use CodeIgniter\Model;

class Model_tugas extends Model
{
    public function all_data()
    {
        return $this->db->table('tbl_tugas')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_tugas.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_tugas.id_user', 'left')
            ->join('tbl_kategori_tugas', 'tbl_kategori_tugas.id_kategori_tugas = tbl_tugas.id_kategori_tugas', 'left')
            ->orderBy('id_tugas', 'DESC')
            ->where('tbl_tugas.id_user', session()->get('id_user'))
            ->get()
            ->getResultArray();
    }
    public function data_user()
    {
        return $this->db->table('tbl_tugas')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_tugas.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_tugas.id_user', 'left')
            ->join('tbl_kategori_tugas', 'tbl_kategori_tugas.id_kategori_tugas = tbl_tugas.id_kategori_tugas', 'left')
            ->orderBy('id_tugas', 'DESC')
            ->get()
            ->getResultArray();
    }

    public function detail_data($id_tugas)
    {
        return $this->db->table('tbl_tugas')
            ->join('tbl_dep', 'tbl_dep.id_dep = tbl_tugas.id_dep', 'left')
            ->join('tbl_user', 'tbl_user.id_user = tbl_tugas.id_user', 'left')
            ->join('tbl_kategori_tugas', 'tbl_kategori_tugas.id_kategori_tugas = tbl_tugas.id_kategori_tugas', 'left')
            ->where('id_tugas', $id_tugas)
            ->get()
            ->getRowArray();
    }

    public function add($data)
    {
        $this->db->table('tbl_tugas')->insert($data);
    }

    public function edit($data)
    {
        $this->db->table('tbl_tugas')
            ->where('id_tugas', $data['id_tugas'])
            ->update($data);
    }

    public function delete_data($data)
    {
        $this->db->table('tbl_tugas')
            ->where('id_tugas', $data['id_tugas'])
            ->delete($data);
    }
}
