<div class="row">
    <div class="col-md-12">
        <div class="box box-primary box-solid">
            <div class="box-header with-border">
                <h3 class="box-title">Data pelatihan_guru</h3>

                <div class="box-tools pull-right">
                    <?php if (session()->level == 1) : ?>
                        <a href="<?= base_url('pelatihan_guru/add') ?>" class="btn btn-primary btn-sm btn-flat">
                            <i class="fa fa-plus"></i> Add</a>
                    <?php endif; ?>
                    <?php if (session()->level == 2) : ?>
                        <a href="<?= base_url('pelatihan_guru/add') ?>" class="btn btn-primary btn-sm btn-flat">
                            <i class="fa fa-plus"></i> Add</a>
                    <?php endif; ?>
                </div>
                <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->
            <div class="box-body">

                <?php
                if (session()->getFlashdata('pesan')) {
                    echo '<div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h4><i class="icon fa fa-check"></i> Success! - ';
                    echo session()->getFlashdata('pesan');
                    echo '</h4></div>';
                }
                ?>
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama </th>
                            <th>Tingkat</th>
                            <th>Penyelenggara</th>
                            <th>jumlah_jam</th>
                            <th>Tahun</th>
                            <th>Lampiran</th>
                            <?php if (session()->level == 1) : ?><th width="100px">Action</th><?php endif; ?>
                            <?php if (session()->level == 2) : ?><th width="100px">Action</th><?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1;
                        foreach ($pelatihan_guru as $key => $value) { ?>
                            <tr>
                                <td><?= $no++; ?></td>
                                <td><?= $value['nama_pelatihan_guru']; ?></td>
                                <td><?= $value['nama_kategori_tingkat']; ?></td>
                                <td><?= $value['penyelenggara']; ?></td>
                                <td><?= $value['jumlah_jam']; ?></td>
                                <td><?= $value['tahun']; ?></td>
                                <td class="text-center">
                                    <a href="<?= base_url('pelatihan_guru/viewpdf/' . $value['id_pelatihan_guru']) ?>">
                                        <i class="fa fa-file-pdf-o fa-2x label-danger"></i></a><br>
                                    <?= number_format($value['ukuran_file'], 0) ?> Byte
                                </td>
                                <td class="text-center">
                                    <?php if (session()->level == 1) : ?>
                                        <a href="<?= base_url('pelatihan_guru/edit/' . $value['id_pelatihan_guru']) ?>" class="btn btn-xs btn-warning">Edit</a>
                                        <button class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete<?= $value['id_pelatihan_guru']; ?>">Delete</button>
                                    <?php endif; ?>
                                    <?php if (session()->level == 2) : ?>
                                        <a href="<?= base_url('pelatihan_guru/edit/' . $value['id_pelatihan_guru']) ?>" class="btn btn-xs btn-warning">Edit</a>
                                        <button class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete<?= $value['id_pelatihan_guru']; ?>">Delete</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>

            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </div>
</div>


<!-- /.modal delete kategori -->
<?php foreach ($pelatihan_guru as $key => $value) { ?>
    <div class="modal fade" id="delete<?= $value['id_pelatihan_guru']; ?>">
        <div class="modal-dialog modal-sm modal-danger">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Hapus User</h4>
                </div>
                <div class="modal-body">

                    Apakah Anda Yakin Ingin Hapus <b><?= $value['nama_pelatihan_guru']; ?></b>..?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Tidak</button>
                    <a href="<?= base_url('pelatihan_guru/delete/' . $value['id_pelatihan_guru']) ?>" type="submit" class="btn btn-primary">Ya</a>
                </div>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal delete kategori -->