<div class="row">
    <div class="col-md-12">
        <div class="box box-primary box-solid">
            <div class="box-header with-border">
                <h3 class="box-title">Data kategori_pelatihan_guru</h3>

                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm btn-flat" data-toggle="modal" data-target="#add">
                        <?php if (session()->id_user == 1) : ?>
                            <i class="fa fa-plus"></i> Add</button>
                <?php endif; ?>
                </div>
                <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <?php
                if (session()->getFlashdata('pesan')) {
                    echo '<div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h4><i class="icon fa fa-check"></i> Success! - ';
                    echo session()->getFlashdata('pesan');
                    echo '</h4></div>';
                }
                ?>
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="80px">No</th>
                            <th>kategori_pelatihan_guru</th>
                            <th width="100px"><?php if (session()->id_user == 1) : ?>Action <?php endif; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1;
                        foreach ($kategori_pelatihan_guru as $key => $value) { ?>
                            <tr>
                                <td><?= $no++; ?></td>
                                <td><?= $value['nama_kategori_pelatihan_guru']; ?></td>
                                <td class="text-center">
                                    <?php if (session()->id_user == 1) : ?>
                                        <button class="btn btn-xs btn-warning" data-toggle="modal" data-target="#edit<?= $value['id_kategori_pelatihan_guru']; ?>">Edit</button>
                                        <button class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete<?= $value['id_kategori_pelatihan_guru']; ?>">Delete</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>

            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </div>
</div>

<!-- /.modal add kategori_pelatihan_guru -->
<div class="modal fade" id="add">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Add kategori_pelatihan_guru</h4>
            </div>
            <div class="modal-body">
                <?php
                echo form_open('kategori_pelatihan_guru/add')
                ?>

                <div class="form-group">
                    <label>kategori_pelatihan_guru</label>
                    <input name="nama_kategori_pelatihan_guru" class="form-control" placeholder="kategori_pelatihan_guru" required>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
            <?php echo form_close() ?>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- end modal add kategori_pelatihan_guru -->


<!-- /.modal edit kategori_pelatihan_guru -->
<?php foreach ($kategori_pelatihan_guru as $key => $value) { ?>
    <div class="modal fade" id="edit<?= $value['id_kategori_pelatihan_guru']; ?>">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit kategori_pelatihan_guru</h4>
                </div>
                <div class="modal-body">
                    <?php
                    echo form_open('kategori_pelatihan_guru/edit/' . $value['id_kategori_pelatihan_guru'])
                    ?>

                    <div class="form-group">
                        <label>kategori_pelatihan_guru</label>
                        <input name="nama_kategori_pelatihan_guru" value="<?= $value['nama_kategori_pelatihan_guru']; ?>" class="form-control" placeholder="kategori_pelatihan_guru" required>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
                <?php echo form_close() ?>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal edit kategori_pelatihan_guru -->


<!-- /.modal delete kategori_pelatihan_guru -->
<?php foreach ($kategori_pelatihan_guru as $key => $value) { ?>
    <div class="modal fade" id="delete<?= $value['id_kategori_pelatihan_guru']; ?>">
        <div class="modal-dialog modal-sm modal-danger">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Delete kategori_pelatihan_guru</h4>
                </div>
                <div class="modal-body">

                    Apakah Anda Yakin Ingin Hapus <?= $value['nama_kategori_pelatihan_guru']; ?>..?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Tidak</button>
                    <a href="<?= base_url('kategori_pelatihan_guru/delete/' . $value['id_kategori_pelatihan_guru']) ?>" type="submit" class="btn btn-primary">Ya</a>
                </div>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal delete kategori_pelatihan_guru -->