<div class="row">
    <div class="col-md-12">
        <div class="box box-primary box-solid">
            <div class="box-header with-border">
                <h3 class="box-title">Data kategori_tugas</h3>

                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm btn-flat" data-toggle="modal" data-target="#add">
                        <?php if (session()->id_user == 1) : ?>
                            <i class="fa fa-plus"></i> Add</button>
                <?php endif; ?>
                </div>
                <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <?php
                if (session()->getFlashdata('pesan')) {
                    echo '<div class="alert alert-success alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h4><i class="icon fa fa-check"></i> Success! - ';
                    echo session()->getFlashdata('pesan');
                    echo '</h4></div>';
                }
                ?>
                <table id="example1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="80px">No</th>
                            <th>kategori_tugas</th>
                            <th width="100px"><?php if (session()->id_user == 1) : ?>Action <?php endif; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1;
                        foreach ($kategori_tugas as $key => $value) { ?>
                            <tr>
                                <td><?= $no++; ?></td>
                                <td><?= $value['nama_kategori_tugas']; ?></td>
                                <td class="text-center">
                                    <?php if (session()->id_user == 1) : ?>
                                        <button class="btn btn-xs btn-warning" data-toggle="modal" data-target="#edit<?= $value['id_kategori_tugas']; ?>">Edit</button>
                                        <button class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete<?= $value['id_kategori_tugas']; ?>">Delete</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>

            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </div>
</div>

<!-- /.modal add kategori_tugas -->
<div class="modal fade" id="add">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Add kategori_tugas</h4>
            </div>
            <div class="modal-body">
                <?php
                echo form_open('kategori_tugas/add')
                ?>

                <div class="form-group">
                    <label>kategori_tugas</label>
                    <input name="nama_kategori_tugas" class="form-control" placeholder="kategori_tugas" required>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
            <?php echo form_close() ?>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- end modal add kategori_tugas -->


<!-- /.modal edit kategori_tugas -->
<?php foreach ($kategori_tugas as $key => $value) { ?>
    <div class="modal fade" id="edit<?= $value['id_kategori_tugas']; ?>">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit kategori_tugas</h4>
                </div>
                <div class="modal-body">
                    <?php
                    echo form_open('kategori_tugas/edit/' . $value['id_kategori_tugas'])
                    ?>

                    <div class="form-group">
                        <label>kategori_tugas</label>
                        <input name="nama_kategori_tugas" value="<?= $value['nama_kategori_tugas']; ?>" class="form-control" placeholder="kategori_tugas" required>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
                <?php echo form_close() ?>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal edit kategori_tugas -->


<!-- /.modal delete kategori_tugas -->
<?php foreach ($kategori_tugas as $key => $value) { ?>
    <div class="modal fade" id="delete<?= $value['id_kategori_tugas']; ?>">
        <div class="modal-dialog modal-sm modal-danger">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Delete kategori_tugas</h4>
                </div>
                <div class="modal-body">

                    Apakah Anda Yakin Ingin Hapus <?= $value['nama_kategori_tugas']; ?>..?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Tidak</button>
                    <a href="<?= base_url('kategori_tugas/delete/' . $value['id_kategori_tugas']) ?>" type="submit" class="btn btn-primary">Ya</a>
                </div>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php } ?>
<!-- end modal delete kategori_tugas -->